
#include "SlippyMapTile.h"
#include "gbos1936/Gbos1936.h"
#include "StringUtils.h"
#include "Tile.h"
#include "ImgMagick.h"
#include "ImageWarpByFunc.h"
#include "ganzc/LatLong-OSGBconversion.h"
#include "ReadKmlFile.h"
#include "OSTN02Perl.h"
#include "ReadDelimitedFile.h"
#include <time.h>
#include <boost/program_options.hpp>
namespace po = boost::program_options;

//#include <wand/magick-wand.h>
//#include <wand/drawing-wand.h>
//#include <Magick++.h>
//rsync --size-only -v -r /var/www/os7 timsc@dev.openstreetmap.org:/home/ooc
//rsync --size-only -v -r /var/www/openlayers/os7 timsc@dev.openstreetmap.org:/home/timsc/public_html/openlayers

#include <boost/filesystem.hpp>   // includes all needed Boost.Filesystem declarations
namespace fs = boost::filesystem;

#include <list>
#include <iostream>
#include <exception>
#include <vector>
using namespace std;
//using namespace Magick;

//class OSTN02Perl gConverter;
class HelmertConverter gConverter;

struct RescaleParams
{
public:
	double xscale, yscale, xori, yori;
};

vector<double> RescaleTransform(vector<double> in, void *userPtr)
{
	struct RescaleParams &params = *(struct RescaleParams *)userPtr;
	vector<double> out;
	out.push_back(in[0] * params.xscale - params.xori);
	out.push_back(in[1] * params.yscale - params.yori);
	return out;
}

int GetResizedSubimage(class Tile &src, class Tile &dst, class ImgMagick &imageIn, class ImgMagick &imageOut)
{
	struct RescaleParams params;
	params.xscale = (src.lonmax - src.lonmin) * dst.sx / ((dst.lonmax - dst.lonmin) * src.sx);
	params.yscale = (src.latmax - src.latmin) * dst.sy / ((dst.latmax - dst.latmin) * src.sy);
	params.xori = params.xscale * src.sx * (dst.lonmin - src.lonmin) / (src.lonmax - src.lonmin);
	params.yori = params.yscale * src.sy * (src.latmax - dst.latmax) / (src.latmax - src.latmin);

	class ImageWarpByFunc warp;
	warp.Warp(imageIn, imageOut, RescaleTransform, &params);

	//cout << "scale " << xscale << "\t" << yscale << endl;
	//cout << "ori " << xori << "\t" << yori << endl;

	//double lat, lon, alt;
	//ConvertGbos1936ToWgs84(302000,588000,0.0,lat,lon, alt);
	//cout << "testA " << lat << "," << lon << endl;
	//cout << "test " << (lon - dstW) * dstWidth / (dstE - dstW) << "," << (dstN - lat) * dstHeight / (dstN - dstS) << endl;
	//cout << dst.sx<<","<<dst.sy << endl;
	


	return 1;
}

//************************

class CopyPixelsWithOsMask
{
public:
	int gnorth, gsouth, geast, gwest, boxset;

	CopyPixelsWithOsMask();
	void UpdateBoundingBox(const char *mapref);
	int CheckIfInBox(double lat, double lon);
	void CopyPixels(class ImgMagick &imageIn, class ImgMagick &imageOut, class Tile &tile);
};

CopyPixelsWithOsMask::CopyPixelsWithOsMask()
{
	gnorth = 0;
	gsouth = 0;
	geast = 0;
	gwest = 0;
	boxset = 0;
}

void CopyPixelsWithOsMask::UpdateBoundingBox(const char *mapref)
{
	int dEasting=0, dNorthing=0;
	OSGBGridRefToRefCoords(mapref,dEasting,dNorthing);

	if(!boxset || gsouth > dNorthing) gsouth = dNorthing;
	if(!boxset || gnorth < dNorthing) gnorth = dNorthing;
	if(!boxset || geast < dEasting) geast = dEasting;
	if(!boxset || gwest > dEasting) gwest = dEasting;
	boxset = 1;
	//double lat=-1.0, lon=-1.0, alt = -1.0;
	//ConvertGbos1936ToWgs84(dEasting, dNorthing,0.0, lat, lon, alt);
}

int CopyPixelsWithOsMask::CheckIfInBox(double lat, double lon)
{
	double pnorth,peast,palt;
	gConverter.ConvertWgs84ToGbos1936(lat,lon, 0.0, peast,pnorth,palt);
	if(pnorth < gsouth) return 0;
	if(pnorth > gnorth) return 0;
	if(peast < gwest) return 0;
	if(peast > geast) return 0;

	return 1;
}

void CopyPixelsWithOsMask::CopyPixels(class ImgMagick &imageIn, class ImgMagick &imageOut, class Tile &tile)
{
	int width = imageIn.GetWidth();
	int height = imageIn.GetHeight();
	int chans = imageIn.GetNumChannels();

	//Check corners (quicker to check then exhaustively check each pixel)
	double lat, lon;
	tile.UnProject(0, 0, lat, lon);
	int cornerCheck = this->CheckIfInBox(lat, lon);
	tile.UnProject(width, 0, lat, lon);
	cornerCheck = cornerCheck && this->CheckIfInBox(lat, lon);
	tile.UnProject(width, height, lat, lon);
	cornerCheck = cornerCheck && this->CheckIfInBox(lat, lon);
	tile.UnProject(0, height, lat, lon);
	cornerCheck = cornerCheck && this->CheckIfInBox(lat, lon);
	//cout << cornerCheck << endl;
	if(cornerCheck || boxset == 0) //Entire tile is in mask
	{
		
		//Copy every pixel
		for(int i=0;i<width;i++)
		for(int j=0;j<height;j++)
		for(int k=0;k<chans;k++)
		{
			double val = imageIn.GetPix(i,j,k);
			imageOut.SetPix(i,j,k,val);
		}
	}
	else
	{
		//Check each pixel and copy if inside mask
		for(int i=0;i<width;i++)
		for(int j=0;j<height;j++)
		for(int k=0;k<chans;k++)
		{
		
			tile.UnProject(i, j, lat, lon);
			int inMask = this->CheckIfInBox(lat, lon);
			if(!inMask) continue;

			double val = imageIn.GetPix(i,j,k);
			imageOut.SetPix(i,j,k,val);
		}
	}

}

void ImageToBlack(class ImgMagick &image)
{
	int width = image.GetWidth();
	int height = image.GetHeight();
	int chans = image.GetNumChannels();

	for(int i=0;i<width;i++)
	for(int j=0;j<height;j++)
	for(int k=0;k<chans;k++)
	{
		image.SetPix(i,j,k,0);
	}
}

//************************************

class SourceKml
{
public:
	class Tile tile;
	class ImgMagick image;
	vector<string> bounds;
	string imgFilename;
	clock_t lastAccess;

	SourceKml() {lastAccess = 0;}
	SourceKml(const SourceKml &a) {operator=(a);}
	virtual ~SourceKml() {}
	SourceKml& operator=(const SourceKml& a)
	{
		tile = a.tile;
		image = a.image;
		bounds = a.bounds;
		imgFilename = a.imgFilename;
		lastAccess = a.lastAccess;
		return *this;
	}
};

//*****************************************

void DrawMarkerPix(class ImgMagick &img, int x, int y, double r, double g, double b)
{
	if(x < 0 || x >= img.GetWidth()) return;
	if(y < 0 || y >= img.GetHeight()) return;
	img.SetPix(x, y, 0, r);
	img.SetPix(x, y, 1, g);
	img.SetPix(x, y, 2, b);
}

void DrawMarker(class ImgMagick &img, double x, double y)
{
	//Draw to tile
	for(int i=-1;i<=1;i++)
	for(int j=-1;j<=1;j++)
	{
		if(i != 0 || j != 0)
			DrawMarkerPix(img,x+(double)i+0.5,y+(double)j+0.5,0.0,0.0,0.0);
		else
			DrawMarkerPix(img,x+(double)i+0.5,y+(double)j+0.5,255.0,0.0,255.0);
	}	
}

//***************************************

int GetBounds(class DelimitedFile &boundsFile, const char *filename, vector<string> &boundsOut)
{
	boundsOut.clear();
	for(unsigned int i=0;i<boundsFile.NumLines();i++)
	{
		class DelimitedFileLine &line = boundsFile.GetLine(i);
		if(line.NumVals() < 3) continue;
		if(strcmp(line[0].GetVals(),filename)!=0) continue;

		//Read details from this line
		for(unsigned int j=1;j<line.NumVals();j++)
		{
			//cout << strlen(line[j].GetVals()) << "," << line[j].GetVals() << endl;
			boundsOut.push_back(line[j].GetVals());
		}
		return boundsOut.size();
	}
	return boundsOut.size();
}

//***************************************

int main(int argc, char ** argv)
{

	
	//Image imageInOut("step.jpg");
	//imageInOut.crop( Geometry(255,255,0,0) );
	//imageInOut.write("test2.png");

	/*class Tile test;
	vector<string> test2;
	string test3;
	int retOpen = ReadKmlFile("/home/tim/dev/os7files/rect/73.kml", test, test3, test2);

	exit(0);*/

	class Tile dst;
	//cout << long2tile(-3.68, zoom) << "," << lat2tile(54.8333,zoom) << endl;
	//cout << long2tile(-3.04, zoom) << "," << lat2tile(55.2446,zoom) << endl;

	vector<class SourceKml> src;
	class DelimitedFile boundsFile;

	string outFolder = "out";
	unsigned int minZoom = 10;
	unsigned int maxZoom = 14;
	string boundsFilename = "bounds.csv";
	vector<string> inputFiles ;
	string execFilename = "gentiles";
	if(argc >= 1) execFilename = argv[0];

	//Process program options using boost library
	po::variables_map vm;
	po::options_description desc("Allowed options");
	try{
	po::positional_options_description pd;
        pd.add("positional", -1); 

	desc.add_options() ("minzoom", po::value<int>(), "Minimum zoom level")
		("maxzoom", po::value<int>(), "Maximum zoom level")
		("output", po::value<string>(), "Output folder")
		("bounds", po::value<string>(), "Bounds filename")
		("positional", po::value<std::vector<std::string> >(), "Input KML files")
		("help","help message");

		//("annot-offset",po::value<double>(),"time offset of anvil annotation track")
	 po::parsed_options parsed = po::command_line_parser(argc, argv).options(desc).allow_unregistered().positional(pd).run();
	po::store(parsed, vm);
	po::notify(vm);

	if(vm.count("help")) {cout << desc << endl; exit(0);}
	if(vm.count("minzoom")) minZoom = vm["minzoom"].as<int>();
	if(vm.count("maxzoom")) maxZoom = vm["maxzoom"].as<int>();
	if(vm.count("output")) outFolder = vm["output"].as<string>();
	if(vm.count("bounds")) boundsFilename = vm["bounds"].as<string>();

	if (vm.count("positional"))
	{
		inputFiles = vm["positional"].as< vector<string> >();
		//for(unsigned int i=0;i<inputFiles.size();i++)
		//	cout << "input file " << inputFiles[i] << endl;
	}

	}
	catch(exception &e)
	{
		cerr << "error: " << e.what() << endl;
	}

	if(inputFiles.size()==0)
	{
		cout << "No input KML files were specified" << endl;
		cout << "Usage: " << execFilename << " [options] one.kml [two.kml ...]" << endl;
		cout << desc << endl; exit(0);
	}

	if(minZoom > maxZoom)
	{
		cout << "Error max zoom is lower than min zoom" << endl;
		cout << desc << endl; exit(0);
	}

	int boundsOpen = boundsFile.Open(boundsFilename.c_str());
	if(boundsOpen < 1) cout << "Could not read "<<boundsOpen<<" file" << endl;
	class Tile sourceBBox; int sourceBBoxSet = 0;

	//For each input file, parse KML into local mem
	for(unsigned int i=0;i<inputFiles.size();i++)
	{
		class SourceKml temp;
		cout << "Source file '" << inputFiles[i] << "'" << endl;
		string filePath = GetFilePath(inputFiles[i]);

		src.push_back(temp);
		class SourceKml &last = src[src.size()-1];
		string imgFilename;
		int ret = ReadKmlFile(inputFiles[i].c_str(), last.tile, imgFilename);
		last.imgFilename = filePath;
		last.imgFilename += "/";
		last.imgFilename += imgFilename;
		if(ret < 1) {cout << "Kml "<<inputFiles[i]<<" not found"; exit(0);}
		cout << last.tile.latmin << "," << last.tile.lonmin << "," << last.tile.latmax << "," << last.tile.lonmax << endl;
		cout << "image filename '" << last.imgFilename << "'" << endl;

		//Update source bounding box
		if(sourceBBox.latmin > last.tile.latmin || !sourceBBoxSet) sourceBBox.latmin = last.tile.latmin;
		if(sourceBBox.latmax < last.tile.latmax || !sourceBBoxSet) sourceBBox.latmax = last.tile.latmax;
		if(sourceBBox.lonmin > last.tile.lonmin || !sourceBBoxSet) sourceBBox.lonmin = last.tile.lonmin;
		if(sourceBBox.lonmax < last.tile.lonmax || !sourceBBoxSet) sourceBBox.lonmax = last.tile.lonmax;
		sourceBBoxSet = 1;

		//int ret = last.image.Open(last.imgFilename.c_str());
		//if(ret < 0){cout << "Filed to open image" << endl;exit(0);}
		//last.bounds.push_back("NR550000");
		//last.bounds.push_back("NR950450");
		string filenameNoPath = RemoveFilePath(inputFiles[i].c_str());
		vector<string> boundsTemp;
		GetBounds(boundsFile,filenameNoPath.c_str(),boundsTemp);
		cout << "bounds (" << boundsTemp.size() << ")";
		for(unsigned int j=0;j<boundsTemp.size();j++) cout << boundsTemp[j] << ",";
		cout << endl;
		last.bounds = boundsTemp;
	}

	cout << "Input files bounding box:" << endl;
	cout << sourceBBox.latmin << "," << sourceBBox.lonmin << "," << sourceBBox.latmax << "," << sourceBBox.lonmax << endl;

	class ImgMagick tile;
	tile.SetNumChannels(3);
	tile.SetWidth(256);
	tile.SetHeight(256);
	class ImgMagick outImg;
	outImg.SetNumChannels(3);
	outImg.SetWidth(256);
	outImg.SetHeight(256);

	//int zoom = 14;
	//for(unsigned int zoom=14;zoom>=8;zoom--)
	for(unsigned int zoom=minZoom;zoom<=maxZoom;zoom++)
	{
	int srcWtile = long2tile(/*-3.68423*/sourceBBox.lonmin, zoom);
	int srcEtile = long2tile(sourceBBox.lonmax, zoom);
	int srcStile = lat2tile(sourceBBox.latmin,zoom);
	int srcNtile = lat2tile(sourceBBox.latmax,zoom);
	cout << "tiles covered " << srcStile << "," << srcWtile << "," << srcNtile << "," << srcEtile << endl;

	//int tileLon = 8024;
	//int tileLat = 5168;
	//For each tile to generate
	for(int tileLon = srcWtile; tileLon <= srcEtile; tileLon ++)
	//for(int tileLon = srcEtile; tileLon >= srcWtile; tileLon --)
	for(int tileLat = srcNtile; tileLat <= srcStile; tileLat ++)
	{
	int needToClearOutTile = 1;

	dst.latmax = tile2lat(tileLat, zoom);
	dst.lonmin = tile2long(tileLon, zoom);
	dst.latmin = tile2lat(tileLat+1, zoom);
	dst.lonmax = tile2long(tileLon+1, zoom);
	dst.sx = outImg.GetWidth();
	dst.sy = outImg.GetHeight();

	string outFilename = outFolder;
	string outFolder0 = outFilename;
	outFilename += "/";
	outFilename += IntToString(zoom);
	string outFolder1 = outFilename;
	outFilename += "/";
	outFilename += IntToString(tileLon);
	string outFolder2 = outFilename;
	outFilename += "/";
	outFilename += IntToString(tileLat);
	outFilename += ".jpg";

	int skipExistingTiles = 1;
	if ( fs::exists( outFilename ) && skipExistingTiles)
	{
		cout << "Already exists: " << outFilename << endl;
		continue;
	}

	//Magick::Image image(src.GetWidth(),src.GetHeight(),"RGB",CharPixel,src.GetInternalDataConst());
	
	//cout << size.width() << "," << size.height() << endl;

	//For each KML source
	int countSrcTilesUsed = 0;
	for(unsigned int t=0;t<src.size();t++)
	{
	class SourceKml &srcKml = src[t];

	//if(srcKml.imgFilename == "000.kml"

	//Check kml src actually contains useful info for this destination tile
	int noOverlap = 0;
	if(srcKml.tile.lonmax < dst.lonmin) noOverlap = 1;
	if(srcKml.tile.lonmin > dst.lonmax) noOverlap = 1;
	if(srcKml.tile.latmax < dst.latmin) noOverlap = 1;
	if(srcKml.tile.latmin > dst.latmax) noOverlap = 1;
	if(noOverlap) continue;	
	if(needToClearOutTile) 
	{
		ImageToBlack(outImg);
		needToClearOutTile = 0;
	}

	ImageToBlack(tile);
	countSrcTilesUsed ++;
	if(countSrcTilesUsed == 1)
	{
		cout << "Generating tile " << tileLon << "," << tileLat << endl;
		cout << "Tile area " << dst.latmin << "," << dst.lonmin << "," << dst.latmax << "," << dst.lonmax << endl;
	}
	cout << "Copying pixels from " << srcKml.imgFilename << endl;

	//Check map is in memory
	if(!srcKml.image.Ready())
	{
		//Count how many tiles in memory
		int maxTilesLoaded = 3;
		int count = 0;
		for(unsigned int i=0;i<src.size();i++)
			if(src[i].image.Ready()) count ++;
		cout << "Currently " << count << " tiles in memory" << endl;

		clock_t lowTime = 0; int lowTimeSet = 0; int lowIndex = -1;
		while(count >= maxTilesLoaded)
		{
			if(count >= maxTilesLoaded + 2)
			{
				cout << "Failing..... too many tiles loaded in memory" << endl;
				return 0;
			}

			//Need to unload a tile. Find tile that has not been recently used.
			//cout << "count " << count << ", src size " << src.size() << endl;
			for(unsigned int i=0;i<src.size();i++)
			{
				//cout << "accessed " << src[i].imgFilename << " at " << (int)src[i].lastAccess << ", ready" << src[i].image.Ready() << endl;
				if((src[i].lastAccess < lowTime || lowTimeSet == 0) && src[i].image.Ready())
				{
					lowTime = src[i].lastAccess;
					lowIndex = i;
					//cout << i << "," << (int)src[i].lastAccess << "," << lowTime << "," << (bool)(src[i].lastAccess < lowTime) << endl;
					//cout << "lowIndex " << lowIndex << endl;
					lowTimeSet = 1;
				}
			}
			
			//Unload tile
			if(lowIndex != -1)
			{
				cout << "Unloading " << src[lowIndex].imgFilename << endl;
				src[lowIndex].image.Clear();
			}
			else
			{
				cout << "Failed to find a tile to unload" << endl;
				return 0;
			}	

			//Recount
			count = 0;
			for(unsigned int i=0;i<src.size();i++)
				if(src[i].image.Ready()) count ++;
		}
		
		//Load required tile into mem
		cout << "Loading " << srcKml.imgFilename << endl;	
		int ret = srcKml.image.Open(srcKml.imgFilename.c_str());
		if(ret < 0) {cout << "Failed to open image " << srcKml.imgFilename << endl;exit(0);}
		srcKml.tile.sx = srcKml.image.GetWidth();
		srcKml.tile.sy = srcKml.image.GetHeight();
	}

	//Update access timer for this tile
	srcKml.lastAccess = clock();

	//Get location in source image containing area of interest
	double xmin = (double)srcKml.tile.sx * (dst.lonmin - srcKml.tile.lonmin) / (srcKml.tile.lonmax - srcKml.tile.lonmin);
	double xmax = (double)srcKml.tile.sx * (dst.lonmax - srcKml.tile.lonmin) / (srcKml.tile.lonmax - srcKml.tile.lonmin);
	double ymin = (double)srcKml.tile.sy * (srcKml.tile.latmax - dst.latmax) / (srcKml.tile.latmax - srcKml.tile.latmin);	
	double ymax = (double)srcKml.tile.sy * (srcKml.tile.latmax - dst.latmin) / (srcKml.tile.latmax - srcKml.tile.latmin);	
	xmin = (int)(xmin - 100);
	xmax = (int)(xmax + 100);
	ymin = (int)(ymin - 100);
	ymax = (int)(ymax + 100);
	if(xmin < 0) xmin = 0;
	if(ymin < 0) ymin = 0;
	if(xmax > srcKml.tile.sx) xmax = srcKml.tile.sx;
	if(ymax > srcKml.tile.sy) ymax = srcKml.tile.sy;

	//cout << "src image roi " << xmin << "," <<xmax<< "\t" << ymin << "," << ymax << endl;
	/*class Tile inter;
	inter.lonmin = ((double)xmin * (src.lonmax - src.lonmin) / (double)src.sx) + src.lonmin;
	inter.lonmax = ((double)xmax * (src.lonmax - src.lonmin) / (double)src.sx) + src.lonmin;
	inter.latmin = src.latmax - ((double)ymax * (src.latmax - src.latmin) / (double)src.sy);
	inter.latmax = src.latmax - ((double)ymin * (src.latmax - src.latmin) / (double)src.sy);
	inter.sx = xmax - xmin;
	inter.sy = ymax - ymin;*/
	//cout << inter.sx << "," << inter.sy << endl;
	//cout << "inter tile area " << inter.lonmin << "," << inter.lonmax << "\t" << inter.latmin << "," <<inter.latmax << endl;



	//cout << "a" << endl;
	//GetSubimage(image,src,temp,inter);
	//temp.write("temp.png");

	//cout << "b" << endl;
	GetResizedSubimage(srcKml.tile,dst,srcKml.image,tile);
	//GetResizedSubimage(inter,dst,temp);
	//cout << "c" << endl;
	
	class CopyPixelsWithOsMask mask;
	for(unsigned int i=0;i<srcKml.bounds.size();i++)
		mask.UpdateBoundingBox(srcKml.bounds[i].c_str());
	mask.CopyPixels(tile, outImg, dst);

	} //End of copy KML source

	//Get OS grid positions of tile corners
	int drawGridCorners = 0;	
	if(drawGridCorners)
	{
	double eaMax=-1.0, noMax=-1.0, heMax=-1.0;
	double eaMin=-1.0, noMin=-1.0, heMin=-1.0;
	gConverter.ConvertWgs84ToGbos1936(dst.latmax, dst.lonmax, 0.0,eaMax, noMax, heMax);
	gConverter.ConvertWgs84ToGbos1936(dst.latmin, dst.lonmin, 0.0,eaMin, noMin, heMin);
	//cout << eaMax << "\t" << noMax << "\t" << heMax << endl;
	//cout << eaMin << "\t" << noMin << "\t" << heMin << endl;

	//Draw grid corners on tile
	for(int ea = floor(eaMin/1000.0);ea < ceil(eaMax/1000.0);ea+=1)
	for(int no = floor(noMin/1000.0);no < ceil(noMax/1000.0);no+=1)
	{
	//cout << ea << "," << no << endl;
		//Convert grid ref to lat lon
		double cornerLat = -1.0, cornerLon = -1.0, cornerHeight = -1.0;
		gConverter.ConvertGbos1936ToWgs84(ea*1000, no*1000, 0.0,cornerLat, cornerLon, cornerHeight);

		//Convert to pixel position
		double cornerx=-1.0, cornery=-1.0;
		dst.Project(cornerLat, cornerLon, cornerx, cornery);

		DrawMarker(outImg, cornerx, cornery);
	}
	}

	//Don't write blank tiles
	if(countSrcTilesUsed == 0) 
		continue;

	//outImg = tile;

		if ( !fs::exists( outFolder0 ) )
			fs::create_directory( outFolder0 );

		if ( !fs::exists( outFolder1 ) )
			fs::create_directory( outFolder1 );

		if ( !fs::exists( outFolder2 ) )
			fs::create_directory( outFolder2 );

	   	outImg.Save(outFilename.c_str());
		//temp.syncPixels();
		//image.syncPixels();

	
	} //End of tile loop
	} //End of zoom loop
}

