
#include "TransformPoly.h"
#include <newmat/newmat.h>
#include "ErrorHandling.h"
#include <iostream>
#include <math.h>
using namespace NEWMAT;

vector<double> PolyProject(vector<double> point, vector<double>pose) 
{
	if(pose.size()==0 || pose.size() % 2)
		ThrowError<logic_error>("Affine transform vector unexpected size",__LINE__,__FILE__);
	if(point.size()!=2)
		ThrowError<logic_error>("Point to transform does not have 2 components",__LINE__,__FILE__);

	int order = ((pose.size() / 2) - 1) / 2;

	/*for(unsigned int i=0;i<pose.size();i++)
	{
		cout << pose[i] << endl;
	}cout << endl;*/

	vector<double> result;
	double tot = 0.0;
	for(int i=0;i<order;i++)
	{
		tot += pow(point[0],i+1) * pose[i*2] + pow(point[1],i+1) * pose[i*2+1];
	}
	tot += pose[(pose.size() / 2) - 1];
	result.push_back(tot);
	
	tot=0.0;
	int indexOff = (pose.size() / 2);
	for(int i=0;i<order;i++)
	{
		tot += pow(point[0],i+1) * pose[i*2+indexOff] + pow(point[1],i+1) * pose[i*2+1+indexOff];
	}
	tot += pose[pose.size() - 1];
	result.push_back(tot);

	//result.push_back(point[0] * pose[0] + point[1] * pose[1] + pose[2]);
	//result.push_back(point[0] * pose[3] + point[1] * pose[4] + pose[5]);

	//result.push_back(point[0] * pose[0] + point[1] * pose[1]+ pow(point[0],2.0) * pose[2] + pow(point[1],2.0) * pose[3] + pose[4]);
	//result.push_back(point[0] * pose[5] + point[1] * pose[6]+ pow(point[0],2.0) * pose[7] + pow(point[1],2.0) * pose[8] + pose[9]);

	return result;
}

/*vector<double> PolyUnProject(vector<double> point, vector<double>pose) 
{	

}*/

//**********************************************************************

PolyProjection::PolyProjection()
{
	order = 2;
}

PolyProjection::~PolyProjection()
{

}

void PolyProjection::Clear()
{
	originalPoints.clear();
	transformedPoints.clear();
}

void PolyProjection::AddPoint(vector<double> original, vector<double> transformed)
{
	originalPoints.push_back(original);
	transformedPoints.push_back(transformed);
}

void PolyProjection::AddPoint(double ox, double oy, double tx, double ty)
{
	vector<double> temp, temp2;
	temp.push_back(ox);temp.push_back(oy);
	temp2.push_back(tx);temp2.push_back(ty);
	AddPoint(temp,temp2);
}

void PolyProjection::AddPoint(double ox, double oy, vector<double> transformed)
{
	vector<double> temp;
	temp.push_back(ox);temp.push_back(oy);
	AddPoint(temp,transformed);
}

void PrintMatrixP(Matrix &m)
{
	for(int i=0;i<m.Nrows();i++)
	{
		for(int j=0;j<m.Ncols();j++)
		{
			cout << m(i+1,j+1) << ",";
		}
		cout << endl;
	}
}

vector<double> PolyProjection::Estimate()
{
	if(originalPoints.size()!=transformedPoints.size())
		ThrowError<logic_error>("Inconsistent number of points in constraints",__LINE__,__FILE__);
	if(originalPoints.size()==0)
		ThrowError<logic_error>("Cannot estimate transform with no points",__LINE__,__FILE__);
	int dim = originalPoints[0].size();

	try
	{
	Matrix po((dim*order)+1,originalPoints.size());
	for(unsigned int i=0;i<originalPoints.size();i++)
	{
		for(unsigned int j=0;j<originalPoints[i].size()*order;j++)
		{
			int ord = j / originalPoints[i].size() + 1;
			//cout << ord << ", " << originalPoints[i][j%2] << ", " << pow(originalPoints[i][j%2],(double)ord) << endl;
			po(j+1,i+1) = pow(originalPoints[i][j%2],(double)ord);
		}
		po((dim*order)+1,i+1) = 1.0;
	}
	//PrintMatrixP(po);

	Matrix pt(dim,transformedPoints.size());
	for(unsigned int i=0;i<transformedPoints.size();i++)
	{
		for(unsigned int j=0;j<transformedPoints[i].size();j++)
			pt(j+1,i+1) = transformedPoints[i][j];
	}
	//PrintMatrixP(pt);

	Matrix invPo = po.t() * (po * po.t()).i(); //Pseudo inverse
	Matrix ptInvPo = pt * invPo;
	//PrintMatrixP(ptInvPo);

	//Convert 2D matrix into 1D for output
	vector<double>out;
	for(int i=0;i<ptInvPo.Nrows();i++)
	{
		for(int j=0;j<ptInvPo.Ncols();j++)
		{
			out.push_back( ptInvPo(i+1,j+1) );
		}
	}

	//Project input to check for accuracy
	cout << "Projection accuracy check" << endl;
	double totalError = 0.0, totalCount = 0.0;
	for(unsigned int i=0;i<originalPoints.size();i++)
	{
		vector<double> proj = PolyProject(originalPoints[i], out);
		cout <<originalPoints[i][0] << "," <<originalPoints[i][1] << "\t";
		cout <<transformedPoints[i][0] << ","<<transformedPoints[i][1] << "\t";
		cout <<proj[0] << "," << proj[1] << "\t";
		double diff = pow(pow(transformedPoints[i][0]-proj[0],2.0)+pow(transformedPoints[i][1]-proj[1],2.0),0.5);
		cout << diff << endl;
		totalError += diff; totalCount ++;
	}
	cout << "Average pixel error " << totalError / totalCount << " units" << endl;

	return out;

	}
	catch(Exception) { cout << Exception::what() << endl; }
	vector<double> empty;
	return empty;
}

